
library(memisc)


library(mclogit)


load("model-cathprot-prayer-relprin-context.RData")


ls()


setCoefTemplate("horizontal.nostar"=t(c(est="($est:#)", se="(($se:#))")))


getCoefTemplate("horizontal.nostar")


m_relprin <- mtable(model_relprin,
                    coef.style="horizontal.nostar",
                    getSummary=getSummary.mmclogit,
                    gs.options=list(
                        rearrange=list(
                            "Religious Principles" = c("Squared" = "religious_principles.sq",                        
                                                "Linear"  = "religious_principles",                           
                                                "$\\times$ Protestant"     = "religious_principles:cathprotProtestant",
                                                "$\\times$ prays rarely"   = "religious_principles:prayRarely",
                                                "$\\times$ prays monthly"  = "religious_principles:prayMonthly",
                                                "$\\times$ prays weekly"   = "religious_principles:prayWeekly",
                                                "$\\times$ prays daily"    = "religious_principles:prayDaily",
                                                "$\\times$ Protestant $\\times$ prays rarely"   = "religious_principles:cathprotProtestant:prayRarely",
                                                "$\\times$ Protestant $\\times$ prays monthly"  = "religious_principles:cathprotProtestant:prayMonthly",
                                                "$\\times$ Protestant $\\times$ prays weekly"   = "religious_principles:cathprotProtestant:prayWeekly",
                                                "$\\times$ Protestant $\\times$ prays daily"    = "religious_principles:cathprotProtestant:prayDaily",
                                                "$\\times$ self-employed"  = "religious_principles:oesch8Self-employed",       
                                                "$\\times$ technical"      = "religious_principles:oesch8Technical",           
                                                "$\\times$ management"     = "religious_principles:oesch8Management",          
                                                "$\\times$ clerks"         = "religious_principles:oesch8Clerks",              
                                                "$\\times$ socio-cultural" = "religious_principles:oesch8Socio-cultural",      
                                                "$\\times$ service worker" = "religious_principles:oesch8Service worker",      
                                                "$\\times$ primary sector" = "religious_principles:oesch8Primary sector",      
                                                "$\\times$ denominational balance"       = "religious_principles:Cath_Prot",
                                                "$\\times$ denominational heterogeneity" = "religious_principles:Denom_Het",
                                                "$\\times$ time" = "religious_principles:time", 
                                                "$\\times$ Protestant     $\\times$ time"  = "religious_principles:cathprotProtestant:time",
                                                "$\\times$ prays rarely   $\\times$ time"  = "religious_principles:prayRarely:time",
                                                "$\\times$ prays monthly  $\\times$ time"  = "religious_principles:prayMonthly:time",
                                                "$\\times$ prays weekly   $\\times$ time"  = "religious_principles:prayWeekly:time",
                                                "$\\times$ prays daily    $\\times$ time"  = "religious_principles:prayDaily:time",
                                                "$\\times$ Protestant     $\\times$ prays rarely   $\\times$ time"  = "religious_principles:prayRarely:time",
                                                "$\\times$ Protestant     $\\times$ prays monthly  $\\times$ time"  = "religious_principles:prayMonthly:time",
                                                "$\\times$ Protestant     $\\times$ prays weekly   $\\times$ time"  = "religious_principles:prayWeekly:time",
                                                "$\\times$ Protestant     $\\times$ prays daily    $\\times$ time"  = "religious_principles:prayDaily:time",
                                                "$\\times$ self-employed  $\\times$ time"  = "religious_principles:time:oesch8Self-employed",  
                                                "$\\times$ technical      $\\times$ time"  = "religious_principles:time:oesch8Technical",      
                                                "$\\times$ management     $\\times$ time"  = "religious_principles:time:oesch8Management",     
                                                "$\\times$ clerks         $\\times$ time"  = "religious_principles:time:oesch8Clerks",         
                                                "$\\times$ socio-cultural $\\times$ time"  = "religious_principles:time:oesch8Socio-cultural", 
                                                "$\\times$ service worker $\\times$ time"  = "religious_principles:time:oesch8Service worker", 
                                                "$\\times$ primary sector $\\times$ time"  = "religious_principles:time:oesch8Primary sector"),                                  
                            "Immigration" = c("Squared" = "immigration.sq",                                 
                                              "Linear"  = "immigration",               
                                              "$\\times$ Protestant"     = "cathprotProtestant:immigration",
                                              "$\\times$ prays rarely"   = "prayRarely:immigration",
                                              "$\\times$ prays monthly"  = "prayMonthly:immigration",
                                              "$\\times$ prays weekly"   = "prayWeekly:immigration",                                    
                                              "$\\times$ self-employed"  = "oesch8Self-employed:immigration",                
                                              "$\\times$ technical"      = "oesch8Technical:immigration",                    
                                              "$\\times$ management"     = "oesch8Management:immigration",                   
                                              "$\\times$ clerks"         = "oesch8Clerks:immigration",                       
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:immigration",               
                                              "$\\times$ service worker" = "oesch8Service worker:immigration",               
                                              "$\\times$ primary sector" = "oesch8Primary sector:immigration",                 
                                              "$\\times$ time" = "time:immigration",          
                                              "$\\times$ Protestant     $\\times$ time" = "cathprotProtestant:time:immigration",
                                              "$\\times$ prays rarely   $\\times$ time" = "prayRarely:time:immigration",
                                              "$\\times$ prays monthly  $\\times$ time" = "prayMonthly:time:immigration",
                                              "$\\times$ prays weekly   $\\times$ time" = "prayWeekly:time:immigration",
                                              "$\\times$ prays daily    $\\times$ time" = "prayDaily:time:immigration",
                                              "$\\times$ self-employed  $\\times$ time" = "time:oesch8Self-employed:immigration",           
                                              "$\\times$ technical      $\\times$ time" = "time:oesch8Technical:immigration",               
                                              "$\\times$ management     $\\times$ time" = "time:oesch8Management:immigration",              
                                              "$\\times$ clerks         $\\times$ time" = "time:oesch8Clerks:immigration",                  
                                              "$\\times$ socio-cultural $\\times$ time" = "time:oesch8Socio-cultural:immigration",          
                                              "$\\times$ service worker $\\times$ time" = "time:oesch8Service worker:immigration",          
                                              "$\\times$ primary sector $\\times$ time" = "time:oesch8Primary sector:immigration"),   
                            "Econ Left--Right"= c("Squared" = "lrecon.sq",                                 
                                              "Linear"  = "lrecon",                                         
                                              "$\\times$ Protestant"     = "cathprotProtestant:lrecon",
                                              "$\\times$ prays rarely"   = "prayRarely:lrecon",
                                              "$\\times$ prays monthly"  = "prayMonthly:lrecon",
                                              "$\\times$ prays weekly"   = "prayWeekly:lrecon",                                    
                                              "$\\times$ self-employed"  = "oesch8Self-employed:lrecon",                
                                              "$\\times$ technical"      = "oesch8Technical:lrecon",                    
                                              "$\\times$ management"     = "oesch8Management:lrecon",                   
                                              "$\\times$ clerks"         = "oesch8Clerks:lrecon",                       
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:lrecon",               
                                              "$\\times$ service worker" = "oesch8Service worker:lrecon",               
                                              "$\\times$ primary sector" = "oesch8Primary sector:lrecon",                 
                                              "$\\times$ time" = "time:lrecon",          
                                              "$\\times$ Protestant     $\\times$ time" = "cathprotProtestant:time:lrecon",
                                              "$\\times$ prays rarely   $\\times$ time" = "prayRarely:time:lrecon",
                                              "$\\times$ prays monthly  $\\times$ time" = "prayMonthly:time:lrecon",
                                              "$\\times$ prays weekly   $\\times$ time" = "prayWeekly:time:lrecon",
                                              "$\\times$ prays daily    $\\times$ time" = "prayDaily:time:lrecon",
                                              "$\\times$ self-employed  $\\times$ time" = "time:oesch8Self-employed:lrecon",           
                                              "$\\times$ technical      $\\times$ time" = "time:oesch8Technical:lrecon",               
                                              "$\\times$ management     $\\times$ time" = "time:oesch8Management:lrecon",              
                                              "$\\times$ clerks         $\\times$ time" = "time:oesch8Clerks:lrecon",                  
                                              "$\\times$ socio-cultural $\\times$ time" = "time:oesch8Socio-cultural:lrecon",          
                                              "$\\times$ service worker $\\times$ time" = "time:oesch8Service worker:lrecon",          
                                              "$\\times$ primary sector $\\times$ time" = "time:oesch8Primary sector:lrecon")
                        )))


m_relprin


m_relprin |> 
    relabel("Var(~(Const.)|CHES_id" = "Var(Party",
            "essround" = "ESS round",
            "CHES_id:" = "Party $\\times$ ",
            "Party x" = "Party $\\times$ ",
            "CHES_id" = "Party",
            fixed=TRUE,gsub=TRUE) |>
    toLatex() |> writeLines(con="cathprot-context-relprin/mtable-cathprot-prayer-context-relprin.tex")




